import QtQuick 2.15
import QtQuick.Controls 2.15
import "../controls"

ScrollView {
    id: _root
    width: 400
    height: 900
    property string name: ""
    property var fonts : []

    signal sigQmlSetProp(string qmlObjectName, string propStrValue)
    signal sigQmlGetProp(string qmlObjectName, string qmlPropName)
    function qmlGetProp(qmlObjectName, qmlPropName) {
        sigQmlGetProp(qmlObjectName, qmlPropName ?? "text")
    }

    signal sigQmlLoadPropImp()
    onSigQmlLoadPropImp: {
        qmlGetProp("script_scriptName")
    }

    Column {
        spacing: 4

        Row {
            spacing: 4
            CustomTextInput {
                objectName: "script_scriptName"
                title: "组件名称"
                enabled: true
                onEditingFinished: {
                    console.log(title + text);
                    sigQmlSetProp(objectName, text)
                }
            }
            Rectangle {
                width: 100
                height: 24
                color: "white"
                border.color: "grey"
                Button {
                    anchors.fill: parent
                    text: "刷新数据"
                    onClicked: {
                        sigQmlLoadPropImp()
                    }
                }
            }
        }
    }
}
